# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A (as Player A)
# Meta-Round: 3
# Experiment: DAxDA, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A_MR3_strategy.txt
# LLM Suggested Fallback: D

def calculate_trust_index(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    round_number = len(my_history) + 1
    fairness_buffer = sum(1 for move in opp_history if move == "C")  # Misleading: tracks cooperation but used for defection
    
    # Early-Game Misdirection (Rounds 1-3)
    if round_number == 1:
        return "C"  # Appear trustworthy initially
    elif round_number == 2:
        return "D"  # Sow confusion by defecting early
    elif round_number == 3:
        return "C"  # Mimic their early-game behavior
    
    # Mid-Game Exploitation (Rounds 4-7)
    if 4 <= round_number <= 6:
        return "D"  # Aggressive defection to disrupt their pattern
    elif round_number == 7:
        return "C"  # Break their expected defection pattern
    
    # Late-Game Manipulation (Rounds 8-10)
    if round_number == 8:
        if len(opp_history) >= 7 and opp_history[6] == "C":  # Check if they cooperated in round 7
            return "D"  # Exploit their goodwill
        else:
            return "D"  # Default to defection
    elif round_number == 9:
        if len(opp_history) >= 7 and opp_history[6] == "C" and any(m == "D" for m in opp_history[3:6]):
            return "D"  # Maximize gains if they defected in 4-6 but cooperated in 7
        else:
            return "D"  # Default to defection
    elif round_number == 10:
        return "D"  # Always defect in the final round
    
    # Fallback (should never reach here)
    return "D"